/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MapTypeAdapterFactory;
import com.google.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

final class MapTypeAdapterFactory$Adapter
extends TypeAdapter {
    private final TypeAdapter keyTypeAdapter;
    private final TypeAdapter valueTypeAdapter;
    private final ObjectConstructor constructor;
    final /* synthetic */ MapTypeAdapterFactory this$0;

    public MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, Gson gson, Type type2, TypeAdapter typeAdapter, Type type3, TypeAdapter typeAdapter2, ObjectConstructor objectConstructor) {
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper;
        TypeAdapterRuntimeTypeWrapper typeAdapterRuntimeTypeWrapper2;
        typeAdapter3.this$0 = mapTypeAdapterFactory;
        TypeAdapter typeAdapter3 = typeAdapterRuntimeTypeWrapper2;
        typeAdapterRuntimeTypeWrapper2 = new TypeAdapterRuntimeTypeWrapper(gson, typeAdapter, type2);
        v1.keyTypeAdapter = typeAdapter3;
        typeAdapter3 = typeAdapterRuntimeTypeWrapper;
        typeAdapterRuntimeTypeWrapper = new TypeAdapterRuntimeTypeWrapper(gson, typeAdapter2, type3);
        v1.valueTypeAdapter = typeAdapter3;
        v1.constructor = objectConstructor;
    }

    private String keyToString(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return String.valueOf(jsonPrimitive.getAsNumber());
            }
            if (jsonPrimitive.isBoolean()) {
                return Boolean.toString(jsonPrimitive.getAsBoolean());
            }
            if (jsonPrimitive.isString()) {
                return jsonPrimitive.getAsString();
            }
            throw new AssertionError();
        }
        if (jsonElement.isJsonNull()) {
            return "null";
        }
        throw new AssertionError();
    }

    @Override
    public Map read(JsonReader jsonReader) {
        Object object = jsonReader.peek();
        if (object == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        JsonToken jsonToken = object;
        object = (Map)this.constructor.construct();
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                Object object2 = this.keyTypeAdapter.read(jsonReader);
                if (object.put(object2, this.valueTypeAdapter.read(jsonReader)) == null) {
                    jsonReader.endArray();
                    continue;
                }
                throw new JsonSyntaxException("duplicate key: " + object2);
            }
            jsonReader.endArray();
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                Object object3 = this.keyTypeAdapter.read(jsonReader);
                if (object.put(object3, this.valueTypeAdapter.read(jsonReader)) == null) continue;
                throw new JsonSyntaxException("duplicate key: " + object3);
            }
            jsonReader.endObject();
        }
        return object;
    }

    public void write(JsonWriter jsonWriter, Map iterator2) {
        int n;
        ArrayList arrayList;
        ArrayList<JsonElement> arrayList2;
        if (iterator2 == null) {
            jsonWriter.nullValue();
            return;
        }
        if (!this.this$0.complexMapKeySerialization) {
            jsonWriter.beginObject();
            for (Map.Entry entry : iterator2.entrySet()) {
                jsonWriter.name(String.valueOf(entry.getKey()));
                this.valueTypeAdapter.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        boolean n2 = false;
        ArrayList<JsonElement> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<JsonElement>(iterator2.size());
        ArrayList arrayList4 = arrayList;
        arrayList = new ArrayList(iterator2.size());
        for (Map.Entry entry : iterator2.entrySet()) {
            JsonElement jsonElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
            arrayList3.add(jsonElement);
            arrayList4.add(entry.getValue());
            int n3 = !jsonElement.isJsonArray() && !jsonElement.isJsonObject() ? 0 : 1;
            n |= n3;
        }
        if (n != 0) {
            jsonWriter.beginArray();
            int n4 = arrayList3.size();
            for (int i = 0; i < n4; ++i) {
                jsonWriter.beginArray();
                Streams.write((JsonElement)arrayList3.get(i), jsonWriter);
                this.valueTypeAdapter.write(jsonWriter, arrayList4.get(i));
                jsonWriter.endArray();
            }
            jsonWriter.endArray();
        } else {
            jsonWriter.beginObject();
            int n5 = arrayList3.size();
            for (int i = 0; i < n5; ++i) {
                jsonWriter.name(this.keyToString((JsonElement)arrayList3.get(i)));
                this.valueTypeAdapter.write(jsonWriter, arrayList4.get(i));
            }
            jsonWriter.endObject();
        }
    }
}

