/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionSpecificBehaviorKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerSource;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

public final class DeserializationContext {
    private final DeserializationComponents components;
    private final NameResolver nameResolver;
    private final DeclarationDescriptor containingDeclaration;
    private final TypeTable typeTable;
    private final VersionRequirementTable versionRequirementTable;
    private final BinaryVersion metadataVersion;
    private final DeserializedContainerSource containerSource;
    private final TypeDeserializer typeDeserializer;
    private final MemberDeserializer memberDeserializer;

    public DeserializationContext(DeserializationComponents object, NameResolver object2, DeclarationDescriptor object3, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion, DeserializedContainerSource deserializedContainerSource, TypeDeserializer typeDeserializer, List list) {
        MemberDeserializer memberDeserializer;
        Intrinsics.checkNotNullParameter(object, "components");
        Intrinsics.checkNotNullParameter(object2, "nameResolver");
        Intrinsics.checkNotNullParameter(object3, "containingDeclaration");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(binaryVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter(list, "typeParameters");
        this.components = object;
        this.nameResolver = object2;
        this.containingDeclaration = object3;
        this.typeTable = typeTable;
        this.versionRequirementTable = versionRequirementTable;
        this.metadataVersion = binaryVersion;
        this.containerSource = deserializedContainerSource;
        object2 = "Deserializer for \"" + object3.getName() + '\"';
        if (deserializedContainerSource == null || (object3 = deserializedContainerSource.getPresentableString()) == null) {
            object3 = "[container not found]";
        }
        DeserializationContext deserializationContext = this;
        deserializationContext.typeDeserializer = object = new TypeDeserializer(this, typeDeserializer, list, (String)object2, (String)object3);
        object = memberDeserializer;
        memberDeserializer = new MemberDeserializer(this);
        deserializationContext.memberDeserializer = object;
    }

    public static /* synthetic */ DeserializationContext childContext$default(DeserializationContext deserializationContext, DeclarationDescriptor declarationDescriptor, List list, NameResolver nameResolver, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion, int n, Object object) {
        if ((n & 4) != 0) {
            nameResolver = deserializationContext.nameResolver;
        }
        if ((n & 8) != 0) {
            typeTable = deserializationContext.typeTable;
        }
        if ((n & 0x10) != 0) {
            versionRequirementTable = deserializationContext.versionRequirementTable;
        }
        if ((n & 0x20) != 0) {
            binaryVersion = deserializationContext.metadataVersion;
        }
        return deserializationContext.childContext(declarationDescriptor, list, nameResolver, typeTable, versionRequirementTable, binaryVersion);
    }

    public final DeserializationComponents getComponents() {
        return this.components;
    }

    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public final DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public final VersionRequirementTable getVersionRequirementTable() {
        return this.versionRequirementTable;
    }

    public final DeserializedContainerSource getContainerSource() {
        return this.containerSource;
    }

    public final TypeDeserializer getTypeDeserializer() {
        return this.typeDeserializer;
    }

    public final MemberDeserializer getMemberDeserializer() {
        return this.memberDeserializer;
    }

    public final StorageManager getStorageManager() {
        return this.components.getStorageManager();
    }

    public final DeserializationContext childContext(DeclarationDescriptor declarationDescriptor, List list, NameResolver nameResolver, TypeTable typeTable, VersionRequirementTable versionRequirementTable, BinaryVersion binaryVersion) {
        TypeDeserializer typeDeserializer;
        Intrinsics.checkNotNullParameter(declarationDescriptor, "descriptor");
        Intrinsics.checkNotNullParameter(list, "typeParameterProtos");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(binaryVersion, "metadataVersion");
        DeserializationComponents deserializationComponents = ((DeserializationContext)((Object)deserializedContainerSource)).components;
        if (!VersionSpecificBehaviorKt.isVersionRequirementTableWrittenCorrectly(binaryVersion)) {
            versionRequirementTable = ((DeserializationContext)((Object)deserializedContainerSource)).versionRequirementTable;
        }
        DeserializationContext deserializationContext = typeDeserializer;
        DeserializationContext deserializationContext2 = deserializedContainerSource;
        DeserializedContainerSource deserializedContainerSource = deserializationContext2.containerSource;
        typeDeserializer = deserializationContext2.typeDeserializer;
        deserializationContext(deserializationComponents, nameResolver, declarationDescriptor, typeTable, versionRequirementTable, binaryVersion, deserializedContainerSource, typeDeserializer, list);
        return deserializationContext;
    }
}

