/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl$Builder;
import okhttp3.HttpUrl$Companion;
import okhttp3.internal.Util;

public final class HttpUrl {
    public static final HttpUrl$Companion Companion = new HttpUrl$Companion(null);
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final List pathSegments;
    private final List queryNamesAndValues;
    private final String fragment;
    private final String url;
    private final boolean isHttps;

    public HttpUrl(String string, String string2, String string3, String string4, int n, List list, List list2, String string5, String string6) {
        Intrinsics.checkNotNullParameter(string, "scheme");
        Intrinsics.checkNotNullParameter(string2, "username");
        Intrinsics.checkNotNullParameter(string3, "password");
        Intrinsics.checkNotNullParameter(string4, "host");
        Intrinsics.checkNotNullParameter(list, "pathSegments");
        Intrinsics.checkNotNullParameter(string6, "url");
        this.scheme = string;
        this.username = string2;
        this.password = string3;
        this.host = string4;
        this.port = n;
        this.pathSegments = list;
        this.queryNamesAndValues = list2;
        this.fragment = string5;
        this.url = string6;
        this.isHttps = Intrinsics.areEqual(string, "https");
    }

    public static final /* synthetic */ char[] access$getHEX_DIGITS$cp() {
        return HEX_DIGITS;
    }

    public final String scheme() {
        return this.scheme;
    }

    public final String host() {
        return this.host;
    }

    public final int port() {
        return this.port;
    }

    public final List pathSegments() {
        return this.pathSegments;
    }

    public final boolean isHttps() {
        return this.isHttps;
    }

    public final URL url() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final URI uri() {
        URI uRI;
        String string;
        string = ((HttpUrl)((Object)string)).newBuilder().reencodeForUri$okhttp().toString();
        URI uRI2 = uRI;
        try {
            uRI = new URI(string);
            return uRI2;
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                uRI2 = URI.create(new Regex("[\\u0000-\\u001F\\u007F-\\u009F\\p{javaWhitespace}]").replace((CharSequence)string, ""));
            }
            catch (Exception exception) {
                throw new RuntimeException(uRISyntaxException);
            }
            Intrinsics.checkNotNullExpressionValue(uRI2, "{\n      // Unlikely edge\u2026Unexpected!\n      }\n    }");
        }
        return uRI2;
    }

    public final String encodedUsername() {
        if (this.username.length() == 0) {
            return "";
        }
        HttpUrl httpUrl = this;
        int n = httpUrl.scheme.length() + 3;
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, ":@", n, n2);
        String string2 = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public final String encodedPassword() {
        if (this.password.length() == 0) {
            return "";
        }
        HttpUrl httpUrl = this;
        int n = StringsKt.indexOf$default((CharSequence)httpUrl.url, ':', this.scheme.length() + 3, false, 4, null) + 1;
        int n2 = StringsKt.indexOf$default((CharSequence)httpUrl.url, '@', 0, false, 6, null);
        String string = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final String encodedPath() {
        HttpUrl httpUrl = this;
        int n = StringsKt.indexOf$default((CharSequence)httpUrl.url, '/', this.scheme.length() + 3, false, 4, null);
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, "?#", n, n2);
        String string2 = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public final List encodedPathSegments() {
        ArrayList<String> arrayList;
        HttpUrl httpUrl = this;
        int n = StringsKt.indexOf$default((CharSequence)httpUrl.url, '/', this.scheme.length() + 3, false, 4, null);
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, "?#", n, n2);
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (n < n2) {
            HttpUrl httpUrl2 = this;
            int n3 = Util.delimiterOffset(httpUrl2.url, '/', ++n, n2);
            String string2 = httpUrl2.url.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            arrayList2.add(string2);
            n = n3;
        }
        return arrayList2;
    }

    public final String encodedQuery() {
        if (this.queryNamesAndValues == null) {
            return null;
        }
        HttpUrl httpUrl = this;
        int n = StringsKt.indexOf$default((CharSequence)httpUrl.url, '?', 0, false, 6, null) + 1;
        String string = httpUrl.url;
        int n2 = string.length();
        n2 = Util.delimiterOffset(string, '#', n, n2);
        String string2 = httpUrl.url.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string2;
    }

    public final String query() {
        StringBuilder stringBuilder;
        if (this.queryNamesAndValues == null) {
            return null;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Companion.toQueryString$okhttp(this.queryNamesAndValues, stringBuilder2);
        return stringBuilder.toString();
    }

    public final String encodedFragment() {
        if (this.fragment == null) {
            return null;
        }
        HttpUrl httpUrl = this;
        int n = StringsKt.indexOf$default((CharSequence)httpUrl.url, '#', 0, false, 6, null) + 1;
        String string = httpUrl.url.substring(n);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return string;
    }

    public final String redact() {
        HttpUrl$Builder httpUrl$Builder = this.newBuilder("/...");
        Intrinsics.checkNotNull(httpUrl$Builder);
        return httpUrl$Builder.username("").password("").build().toString();
    }

    public final HttpUrl resolve(String string) {
        Intrinsics.checkNotNullParameter(string, "link");
        HttpUrl$Builder httpUrl$Builder = ((HttpUrl)((Object)httpUrl$Builder)).newBuilder(string);
        return httpUrl$Builder == null ? null : httpUrl$Builder.build();
    }

    public final HttpUrl$Builder newBuilder() {
        HttpUrl$Builder httpUrl$Builder;
        HttpUrl$Builder httpUrl$Builder2 = httpUrl$Builder;
        httpUrl$Builder2();
        httpUrl$Builder2.setScheme$okhttp(this.scheme);
        httpUrl$Builder2.setEncodedUsername$okhttp(this.encodedUsername());
        httpUrl$Builder2.setEncodedPassword$okhttp(this.encodedPassword());
        httpUrl$Builder.setHost$okhttp(this.host);
        int n = this.port != Companion.defaultPort(this.scheme) ? this.port : -1;
        HttpUrl$Builder httpUrl$Builder3 = httpUrl$Builder2;
        HttpUrl$Builder httpUrl$Builder4 = httpUrl$Builder2;
        httpUrl$Builder4.setPort$okhttp(n);
        httpUrl$Builder4.getEncodedPathSegments$okhttp().clear();
        httpUrl$Builder4.getEncodedPathSegments$okhttp().addAll(this.encodedPathSegments());
        httpUrl$Builder2.encodedQuery(this.encodedQuery());
        httpUrl$Builder3.setEncodedFragment$okhttp(this.encodedFragment());
        return httpUrl$Builder3;
    }

    public final HttpUrl$Builder newBuilder(String string) {
        Object object;
        Intrinsics.checkNotNullParameter(string, "link");
        try {
            object = new HttpUrl$Builder().parse$okhttp((HttpUrl)object, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        return object;
    }

    public boolean equals(Object object) {
        return object instanceof HttpUrl && Intrinsics.areEqual(((HttpUrl)object).url, this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }
}

