/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Interceptor$Chain;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Request$Builder;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Response$Builder;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealResponseBody;
import okio.BufferedSource;
import okio.GzipSource;
import okio.Okio;
import okio.Source;

public final class BridgeInterceptor
implements Interceptor {
    private final CookieJar cookieJar;

    public BridgeInterceptor(CookieJar cookieJar) {
        Intrinsics.checkNotNullParameter(cookieJar, "cookieJar");
        this.cookieJar = cookieJar;
    }

    private final String cookieHeader(List list) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = 0;
        for (Object t : list) {
            int n2 = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Cookie cookie = (Cookie)t;
            if (n > 0) {
                stringBuilder2.append("; ");
            }
            stringBuilder2.append(cookie.name()).append('=').append(cookie.value());
            n = n2;
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    public Response intercept(Interceptor$Chain object) {
        Object object2;
        Interceptor$Chain interceptor$Chain = object;
        Intrinsics.checkNotNullParameter(interceptor$Chain, "chain");
        Object object3 = interceptor$Chain.request();
        Request$Builder request$Builder = ((Request)object3).newBuilder();
        RequestBody requestBody = ((Request)object3).body();
        if (requestBody != null) {
            long l;
            object2 = requestBody.contentType();
            if (object2 != null) {
                request$Builder.header("Content-Type", ((MediaType)object2).toString());
            }
            if ((l = requestBody.contentLength()) != -1L) {
                Request$Builder request$Builder2 = request$Builder;
                request$Builder2.header("Content-Length", String.valueOf(l));
                request$Builder2.removeHeader("Transfer-Encoding");
            } else {
                Request$Builder request$Builder3 = request$Builder;
                request$Builder3.header("Transfer-Encoding", "chunked");
                request$Builder3.removeHeader("Content-Length");
            }
        }
        if (((Request)object3).header("Host") == null) {
            request$Builder.header("Host", Util.toHostHeader$default(((Request)object3).url(), false, 1, null));
        }
        if (((Request)object3).header("Connection") == null) {
            request$Builder.header("Connection", "Keep-Alive");
        }
        boolean bl = false;
        if (((Request)object3).header("Accept-Encoding") == null && ((Request)object3).header("Range") == null) {
            bl = true;
            request$Builder.header("Accept-Encoding", "gzip");
        }
        if ((object2 = ((BridgeInterceptor)object4).cookieJar.loadForRequest(((Request)object3).url())).isEmpty() ^ true) {
            request$Builder.header("Cookie", ((BridgeInterceptor)object4).cookieHeader((List)object2));
        }
        if (((Request)object3).header("User-Agent") == null) {
            request$Builder.header("User-Agent", "okhttp/4.10.0");
        }
        object = object.proceed(request$Builder.build());
        Object object4 = ((Request)object3).url();
        HttpHeaders.receiveHeaders(((BridgeInterceptor)object4).cookieJar, (HttpUrl)object4, ((Response)object).headers());
        object4 = ((Response)object).newBuilder().request((Request)object3);
        if (bl && StringsKt.equals("gzip", Response.header$default((Response)object, "Content-Encoding", null, 2, null), true) && HttpHeaders.promisesBody((Response)object) && (object3 = ((Response)object).body()) != null) {
            GzipSource gzipSource;
            Object object5 = object;
            Object object6 = object;
            object = gzipSource;
            gzipSource = new GzipSource(((ResponseBody)object3).source());
            ((Response$Builder)object4).headers(((Response)object6).headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build());
            object3 = Response.header$default((Response)object5, "Content-Type", null, 2, null);
            object = Okio.buffer((Source)object);
            ((Response$Builder)object4).body(new RealResponseBody((String)object3, -1L, (BufferedSource)object));
        }
        return ((Response$Builder)object4).build();
    }
}

