/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.net.ssl.SSLSockets;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.android.Android10SocketAdapter$Companion;
import okhttp3.internal.platform.android.SocketAdapter;

public final class Android10SocketAdapter
implements SocketAdapter {
    public static final Android10SocketAdapter$Companion Companion = new Android10SocketAdapter$Companion(null);

    @Override
    public boolean matchesSocket(SSLSocket sSLSocket) {
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket2, "sslSocket");
        return SSLSockets.isSupportedSocket((SSLSocket)sSLSocket2);
    }

    @Override
    public boolean isSupported() {
        return Companion.isSupported();
    }

    @Override
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket2, "sslSocket");
        Object object = sSLSocket2.getApplicationProtocol();
        if (object == null ? true : Intrinsics.areEqual(object, "")) {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String stringArray, List list) {
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(list, "protocols");
        try {
            SSLSockets.setUseSessionTickets((SSLSocket)sSLSocket2, (boolean)true);
            SSLParameters sSLParameters = sSLSocket2.getSSLParameters();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Android internal error", illegalArgumentException);
        }
        stringArray = Platform.Companion.alpnProtocolNames(list).toArray(new String[0]);
        if (stringArray == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        SSLParameters sSLParameters = sSLParameters;
        sSLParameters.setApplicationProtocols(stringArray);
        sSLSocket.setSSLParameters(sSLParameters);
    }
}

