/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.security.MessageDigest;
import javax.crypto.Mac;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSource;
import okio.HashingSource$Companion;
import okio.Segment;
import okio.Source;

public final class HashingSource
extends ForwardingSource {
    public static final HashingSource$Companion Companion = new HashingSource$Companion(null);
    private final MessageDigest messageDigest;
    private final Mac mac;

    public HashingSource(Source source2, MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(messageDigest, "digest");
        super(source2);
        this.messageDigest = messageDigest;
        this.mac = null;
    }

    public HashingSource(Source source2, String string) {
        HashingSource hashingSource = messageDigest;
        String string2 = string;
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(string2, "algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        Intrinsics.checkNotNullExpressionValue(messageDigest, "getInstance(algorithm)");
        hashingSource(source2, messageDigest);
    }

    @Override
    public long read(Buffer buffer, long l) {
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullParameter(buffer2, "sink");
        l = super.read(buffer2, l);
        if (l != -1L) {
            long l2;
            Buffer buffer3 = buffer;
            long l3 = buffer3.size() - l;
            Segment segment = buffer3.head;
            Intrinsics.checkNotNull(segment);
            for (l2 = (v505667).size(); l2 > l3; l2 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
                Intrinsics.checkNotNull(segment);
            }
            while (l2 < buffer.size()) {
                int n = (int)((long)segment.pos + l3 - l2);
                MessageDigest messageDigest = this.messageDigest;
                if (messageDigest != null) {
                    messageDigest.update(segment.data, n, segment.limit - n);
                } else {
                    Mac mac = this.mac;
                    Intrinsics.checkNotNull(mac);
                    mac.update(segment.data, n, segment.limit - n);
                }
                segment = segment.next;
                Intrinsics.checkNotNull(segment);
                l3 = l2 += (long)(segment.limit - segment.pos);
            }
        }
        return l;
    }

    public final ByteString hash() {
        Object object;
        MessageDigest messageDigest = ((HashingSource)object).messageDigest;
        if (messageDigest != null) {
            object = messageDigest.digest();
        } else {
            Mac mac = ((HashingSource)object).mac;
            Intrinsics.checkNotNull(mac);
            object = mac.doFinal();
        }
        Intrinsics.checkNotNullExpressionValue(object, "result");
        return new ByteString((byte[])object);
    }
}

