/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.misc.MurmurHash;

public class IntervalSet
implements IntSet {
    public static final IntervalSet COMPLETE_CHAR_SET = IntervalSet.of(0, 0x10FFFF);
    public static final IntervalSet EMPTY_SET;
    protected List intervals;
    protected boolean readonly;

    public IntervalSet(IntervalSet intervalSet) {
        this(new int[0]);
        this.addAll(intervalSet);
    }

    public IntervalSet(int ... nArray) {
        if (nArray == null) {
            ArrayList arrayList;
            IntervalSet intervalSet = arrayList2;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList(2);
            intervalSet.intervals = arrayList2;
        } else {
            ((IntervalSet)((Object)arrayList2)).intervals = new ArrayList(nArray.length);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                ((IntervalSet)((Object)arrayList2)).add(nArray[i]);
            }
        }
    }

    public static IntervalSet of(int n) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.add(n);
        return intervalSet;
    }

    public static IntervalSet of(int n, int n2) {
        IntervalSet intervalSet = new IntervalSet(new int[0]);
        intervalSet.add(n, n2);
        return intervalSet;
    }

    public static IntervalSet subtract(IntervalSet intervalSet, IntervalSet intervalSet2) {
        if (intervalSet != null && !intervalSet.isNil()) {
            IntervalSet intervalSet3;
            IntervalSet intervalSet4 = intervalSet3;
            intervalSet3 = new IntervalSet(intervalSet);
            if (intervalSet2 != null && !intervalSet2.isNil()) {
                int n = 0;
                int n2 = 0;
                while (n < intervalSet4.intervals.size() && n2 < intervalSet2.intervals.size()) {
                    Interval interval = (Interval)intervalSet4.intervals.get(n);
                    Interval interval2 = (Interval)intervalSet2.intervals.get(n2);
                    int n3 = interval.a;
                    if (interval2.b < n3) {
                        ++n2;
                        continue;
                    }
                    int n4 = interval2.a;
                    if (n4 > interval.b) {
                        ++n;
                        continue;
                    }
                    Interval interval3 = null;
                    Interval interval4 = null;
                    if (n4 > n3) {
                        Interval interval5;
                        interval3 = interval5;
                        interval5 = new Interval(interval.a, interval2.a - 1);
                    }
                    if (interval2.b < interval.b) {
                        Interval interval6;
                        interval4 = interval6;
                        int n5 = interval2.b + 1;
                        interval6 = new Interval(n5, interval.b);
                    }
                    if (interval3 != null) {
                        if (interval4 != null) {
                            IntervalSet intervalSet5 = intervalSet4;
                            intervalSet5.intervals.set(n, interval3);
                            intervalSet5.intervals.add(++n, interval4);
                            ++n2;
                            continue;
                        }
                        intervalSet4.intervals.set(n, interval3);
                        ++n;
                        continue;
                    }
                    if (interval4 != null) {
                        intervalSet4.intervals.set(n, interval4);
                        ++n2;
                        continue;
                    }
                    intervalSet4.intervals.remove(n);
                }
                return intervalSet4;
            }
            return intervalSet4;
        }
        return new IntervalSet(new int[0]);
    }

    static {
        COMPLETE_CHAR_SET.setReadonly(true);
        EMPTY_SET = new IntervalSet(new int[0]);
        EMPTY_SET.setReadonly(true);
    }

    public void add(int n) {
        if (!this.readonly) {
            int n2 = n;
            this.add(n2, n2);
            return;
        }
        throw new IllegalStateException("can't alter readonly IntervalSet");
    }

    public void add(int n, int n2) {
        this.add(Interval.of(n, n2));
    }

    protected void add(Interval interval) {
        if (!((IntervalSet)((Object)interval3)).readonly) {
            if (interval.b < interval.a) {
                return;
            }
            ListIterator<Interval> listIterator = ((IntervalSet)((Object)interval3)).intervals.listIterator();
            while (listIterator.hasNext()) {
                Interval interval2 = (Interval)listIterator.next();
                if (interval.equals(interval2)) {
                    return;
                }
                if (!interval.adjacent(interval2) && interval.disjoint(interval2)) {
                    if (!interval.startsBeforeDisjoint(interval2)) continue;
                    ListIterator<Interval> listIterator2 = listIterator;
                    listIterator2.previous();
                    listIterator2.add(interval);
                    return;
                }
                Interval interval3 = interval.union(interval2);
                listIterator.set(interval3);
                while (listIterator.hasNext() && (interval3.adjacent(interval = (Interval)listIterator.next()) || !interval3.disjoint(interval))) {
                    ListIterator<Interval> listIterator3 = listIterator;
                    ListIterator<Interval> listIterator4 = listIterator;
                    listIterator4.remove();
                    listIterator4.previous();
                    listIterator3.set(interval3.union(interval));
                    listIterator3.next();
                }
                return;
            }
            ((IntervalSet)((Object)interval3)).intervals.add(interval);
            return;
        }
        throw new IllegalStateException("can't alter readonly IntervalSet");
    }

    public IntervalSet addAll(IntSet object) {
        if (object == null) {
            return this;
        }
        if (object instanceof IntervalSet) {
            object = (IntervalSet)object;
            int n = ((IntervalSet)object).intervals.size();
            for (int i = 0; i < n; ++i) {
                Interval interval = (Interval)((IntervalSet)object).intervals.get(i);
                int n2 = interval.a;
                this.add(n2, interval.b);
            }
        } else {
            object = object.toList().iterator();
            while (object.hasNext()) {
                this.add((Integer)object.next());
            }
        }
        return this;
    }

    public IntervalSet complement(IntSet intSet) {
        if (intSet != null && !intSet.isNil()) {
            if (intSet instanceof IntervalSet) {
                intSet = (IntervalSet)intSet;
            } else {
                IntervalSet intervalSet;
                IntervalSet intervalSet2 = intervalSet;
                intervalSet2(new int[0]);
                intervalSet.addAll(intSet);
                intSet = intervalSet2;
            }
            return ((IntervalSet)intSet).subtract(this);
        }
        return null;
    }

    public IntervalSet subtract(IntSet intSet) {
        if (intSet != null && !intSet.isNil()) {
            if (intSet instanceof IntervalSet) {
                return IntervalSet.subtract(this, (IntervalSet)intSet);
            }
            IntervalSet intervalSet = new IntervalSet(new int[0]);
            intervalSet.addAll(intSet);
            return IntervalSet.subtract(this, intervalSet);
        }
        return new IntervalSet(this);
    }

    public IntervalSet or(IntSet intSet) {
        IntervalSet intervalSet;
        IntervalSet intervalSet2 = intervalSet;
        intervalSet2(new int[0]);
        intervalSet2.addAll(this);
        intervalSet.addAll(intSet);
        return intervalSet;
    }

    public boolean contains(int n) {
        int n2 = 0;
        int n3 = this.intervals.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Interval interval = (Interval)this.intervals.get(n4);
            int n5 = interval.a;
            if (interval.b < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNil() {
        List list = ((IntervalSet)((Object)list)).intervals;
        return list == null || list.isEmpty();
    }

    public int getMinElement() {
        if (!this.isNil()) {
            return ((Interval)this.intervals.get((int)0)).a;
        }
        throw new RuntimeException("set is empty");
    }

    public int hashCode() {
        int n = MurmurHash.initialize();
        for (Interval interval : this.intervals) {
            n = MurmurHash.update(MurmurHash.update(n, interval.a), interval.b);
        }
        return MurmurHash.finish(n, this.intervals.size() * 2);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof IntervalSet) {
            IntervalSet intervalSet = intervalSet2;
            IntervalSet intervalSet2 = (IntervalSet)object;
            return intervalSet.intervals.equals(intervalSet2.intervals);
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Object object = this.intervals;
        if (object != null && !object.isEmpty()) {
            if (this.size() > 1) {
                stringBuilder2.append("{");
            }
            object = this.intervals.iterator();
            while (object.hasNext()) {
                Interval interval = (Interval)object.next();
                int n = interval.a;
                int n2 = interval.b;
                if (n == n2) {
                    if (n == -1) {
                        stringBuilder2.append("<EOF>");
                    } else if (bl) {
                        stringBuilder2.append("'").appendCodePoint(n).append("'");
                    } else {
                        stringBuilder2.append(n);
                    }
                } else if (bl) {
                    stringBuilder2.append("'").appendCodePoint(n).append("'..'").appendCodePoint(n2).append("'");
                } else {
                    stringBuilder2.append(n).append("..").append(n2);
                }
                if (!object.hasNext()) continue;
                stringBuilder2.append(", ");
            }
            if (this.size() > 1) {
                stringBuilder2.append("}");
            }
            return stringBuilder2.toString();
        }
        return "{}";
    }

    public String toString(Vocabulary vocabulary) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Object object = this.intervals;
        if (object != null && !object.isEmpty()) {
            if (this.size() > 1) {
                stringBuilder2.append("{");
            }
            object = this.intervals.iterator();
            while (object.hasNext()) {
                Interval interval = (Interval)object.next();
                int n = interval.a;
                int n2 = interval.b;
                if (n == n2) {
                    stringBuilder2.append(this.elementName(vocabulary, n));
                } else {
                    for (int i = n; i <= n2; ++i) {
                        if (i > n) {
                            stringBuilder2.append(", ");
                        }
                        stringBuilder2.append(this.elementName(vocabulary, i));
                    }
                }
                if (!object.hasNext()) continue;
                stringBuilder2.append(", ");
            }
            if (this.size() > 1) {
                stringBuilder2.append("}");
            }
            return stringBuilder2.toString();
        }
        return "{}";
    }

    protected String elementName(Vocabulary vocabulary, int n) {
        if (n == -1) {
            return "<EOF>";
        }
        if (n == -2) {
            return "<EPSILON>";
        }
        return vocabulary.getDisplayName(n);
    }

    public int size() {
        int n = 0;
        int n2 = ((IntervalSet)((Object)interval)).intervals.size();
        if (n2 == 1) {
            Interval interval = (Interval)((IntervalSet)((Object)interval)).intervals.get(0);
            return interval.b - interval.a + 1;
        }
        for (int i = 0; i < n2; ++i) {
            Interval interval = (Interval)((IntervalSet)((Object)interval)).intervals.get(i);
            n += interval.b - interval.a + 1;
        }
        return n;
    }

    @Override
    public List toList() {
        ArrayList<Integer> arrayList;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        int n = this.intervals.size();
        for (int i = 0; i < n; ++i) {
            int n2 = ((Interval)this.intervals.get((int)i)).b;
            for (int j = (v541647).a; j <= n2; ++j) {
                arrayList2.add(j);
            }
        }
        return arrayList2;
    }

    public void remove(int n) {
        if (!this.readonly) {
            int n2 = this.intervals.size();
            for (int i = 0; i < n2; ++i) {
                Interval interval = (Interval)this.intervals.get(i);
                int n3 = interval.a;
                int n4 = interval.b;
                if (n < n3) break;
                if (n == n3 && n == n4) {
                    this.intervals.remove(i);
                    break;
                }
                if (n == n3) {
                    interval.a = n3 + 1;
                    break;
                }
                if (n == n4) {
                    interval.b = n4 - 1;
                    break;
                }
                if (n <= n3 || n >= n4) continue;
                interval.b = n - 1;
                this.add(n + 1, n4);
            }
            return;
        }
        throw new IllegalStateException("can't alter readonly IntervalSet");
    }

    public void setReadonly(boolean bl) {
        if (this.readonly && !bl) {
            throw new IllegalStateException("can't alter readonly IntervalSet");
        }
        this.readonly = bl;
    }
}

